/**********
* File: CDGL_IDirect3DCubeTexture9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DCubeTexture9. 
					 This class is our concrete implementation of IDirect3DCubeTexture9 interface in Direct3D9. The class IDirect3DCubeTexture9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

* Modified by  : Bala 

**********/

#ifndef __CDGL_IDIRECT3DCUBETEXTURE9_H__
#define __CDGL_IDIRECT3DCUBETEXTURE9_H__

#include <Carbon/Carbon.h>
#include <iostream>

#include "DXGraphics.h"
#include "CDGL_IDirect3DSurface9.h"
#include "d3d9.h"

#ifndef LIB_CHANGES
#include "OZone/ITexture.h"
#include "OZone/GraphicsInit.h"
#else
#include "ITexture.h"
#include "GraphicsInit.h"
#endif	// LIB_CHANGES

class CDGL_IDirect3DCubeTexture9 : public IDirect3DCubeTexture9
{

	public:
	
		CDGL_IDirect3DCubeTexture9(IDirect3DDevice9 *in_pDevice, UINT in_lEdgeLength, UINT in_lLevels, DWORD in_lUsage, D3DFORMAT in_lFormat, D3DPOOL in_Pool);
		~CDGL_IDirect3DCubeTexture9();
		
		/*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DResource9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT SetPrivateData( REFGUID refguid,CONST void* pData,DWORD SizeOfData,DWORD Flags);
		HRESULT GetPrivateData( REFGUID refguid,void* pData,DWORD* pSizeOfData);
		HRESULT FreePrivateData( REFGUID refguid);
		DWORD SetPriority( DWORD PriorityNew);
		DWORD GetPriority();
		void PreLoad();
		D3DRESOURCETYPE GetType();
		
		/*** IDirect3DBaseTexture9 methods ***/
		DWORD SetLOD( DWORD LODNew);
		DWORD GetLOD();
		DWORD GetLevelCount();
		HRESULT SetAutoGenFilterType( D3DTEXTUREFILTERTYPE FilterType);
		D3DTEXTUREFILTERTYPE GetAutoGenFilterType();
		void GenerateMipSubLevels();
		
		/*** IDirect3DCubeTexture9 methods ***/
		HRESULT GetLevelDesc( UINT Level,D3DSURFACE_DESC *pDesc);
		HRESULT GetCubeMapSurface( D3DCUBEMAP_FACES FaceType,UINT Level,IDirect3DSurface9** ppCubeMapSurface);
		HRESULT LockRect( D3DCUBEMAP_FACES FaceType,UINT Level,D3DLOCKED_RECT* pLockedRect,CONST RECT* pRect,DWORD Flags);
		HRESULT UnlockRect( D3DCUBEMAP_FACES FaceType,UINT Level);
		HRESULT AddDirtyRect( D3DCUBEMAP_FACES FaceType,CONST RECT* pDirtyRect);
		
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• Additional methods •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|
			
		private:
	
		//! Member variables
		IDirect3DDevice9	*	m_pDevice;
		UINT					m_lEdgeLength;
		UINT					m_lLevels;
		DWORD					m_lUsage;
		D3DFORMAT				m_Format;
		D3DPOOL					m_Pool;
		DWORD					m_lLod;
		DWORD					m_lPriority;
		int						m_lRefCount;
		
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• SMARTDX •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|
		// bala : using surfaces to store mips instead of holding raw memory pointer
		//void					**m_pLocalImage[6]; 
		CDGL_IDirect3DSurface9	**mSurfaces[6];	
	
		ITexture				mTexture;
	
		void					_initTextureSurfaces();
	
};

#endif //__CDGL_IDIRECT3DCUBETEXTURE9_H__

